-- Sequence Operations Benchmarks 

without type_check

constant BENCH_TIME = 15   -- run for at least this many seconds
constant SIZE = 100        -- sequence size for init, add

-- We check the time after performing each "batch". The overhead of checking
-- the time should be negligible. However we should check often enough so 
-- a very slow machine running QBasic does not take too long to perform a 
-- single batch.
constant INIT_BATCH = 2000 
constant ADD_BATCH = 1000 
constant LOOKUP_BATCH = 2000
constant SLICE_BATCH = 5
constant CONCAT_BATCH = 5

constant CONCAT_SIZE = 5000
constant SCREEN = 1

atom t, cycles

puts(SCREEN, "\n\t\tEuphoria Sequence Benchmarks\n")

sequence x, y, z

printf(SCREEN, "\n* Initializing a length-%d sequence ---> ", SIZE)
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for j = 1 to INIT_BATCH do
	z = repeat(999, SIZE)
    end for
    cycles = cycles + INIT_BATCH
end while
t = time() - t
printf(SCREEN, "%d initializations per second\n", cycles / t)


printf(SCREEN, "\n* Adding two length-%d sequences ---> ", SIZE)

x = rand(repeat(999, SIZE))
y = rand(repeat(999, SIZE))

cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for j = 1 to ADD_BATCH do
	z = x + y   -- add two sequences
    end for
    cycles = cycles + ADD_BATCH
end while
t = time() - t
printf(SCREEN, "%5d sequence-adds per second\n", cycles / t)

puts(SCREEN, "\n* Appending to a sequence ---> ")
sequence s
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for j = 1 to CONCAT_BATCH do
	s = ""
	for k = 1 to CONCAT_SIZE do
	    s = append(s, '*')
	end for
    end for
    cycles = cycles + CONCAT_BATCH * CONCAT_SIZE
end while
t = time() - t
printf(SCREEN, "%d appends per second\n", cycles / t)


puts(SCREEN, "\n* Slicing a sequence ---> ")
sequence partial
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for j = 1 to SLICE_BATCH do
	partial = s 
	while length(partial) >= 2 do
	    -- delete an element from each end
	    partial = partial[2..length(partial)-1]
	end while
    end for
    cycles = cycles + SLICE_BATCH * length(s) / 2
end while
t = time() - t
printf(SCREEN, "%d slices per second\n", cycles / t)


puts(SCREEN, "\n* Name look-up ---> ")

sequence states
states = {
  "Kentucky", "Alabama", "California", "Washington", "Ohio", "Texas",
  "Nevada", "Florida", "Wyoming", "New York", "Maine", "Massachusetts",
  "North Carolina", "South Carolina", "North Dakota", "South Dakota",
  "Mississippi", "Arizona", "Hawaii", "Alaska", "Oregon", "Michigan",
  "Illinois", "Pennsylvania", "Kansas", "Virginia", "New Mexico", 
  "Rhode Island", "New Hampshire", "Delaware", "Tennessee", "Colorado",
  "Wisconsin", "Vermont", "Indiana", "Maryland", "Connecticut", "Louisiana",
  "Missouri", "Minnesota", "Iowa", "Idaho", "Arkansas", "Montana",
  "Nebraska", "Georgia", "West Virginia", "Utah", "New Jersey",  "Oklahoma"
}

cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for i = 1 to LOOKUP_BATCH do
	if find("Oklahoma", states) != 50 then
	    puts(SCREEN, "whoops!\n")
	end if
    end for
    cycles = cycles + LOOKUP_BATCH
end while
t = time() - t
printf(SCREEN, "%d look-ups per second\n", cycles / t)

without warning

